/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanLanguageMethodMissingParenthesisTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testFooCorrect() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").filter((Predicate)this.method(BeanLanguageMethodMissingParenthesisTest.class, "couldThisBeFoo(${body}, ${header.foo})")).to("mock:foo")).end().to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"yes");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"no");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFooMissingParenthesis() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").filter((Predicate)this.method(BeanLanguageMethodMissingParenthesisTest.class, "couldThisBeFoo(${body}, ${header.foo}")).to("mock:foo")).end().to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"yes"), (String)"Should throw exception");
        IllegalArgumentException iae = BeanLanguageMethodMissingParenthesisTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Method should end with parenthesis, was couldThisBeFoo(${body}, ${header.foo}", (Object)iae.getMessage());
    }

    @Test
    public void testFooInvalidName() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").filter((Predicate)this.method(BeanLanguageMethodMissingParenthesisTest.class, "--couldThisBeFoo(${body}, ${header.foo})")).to("mock:foo")).end().to("mock:result");
            }
        });
        this.context.start();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"yes"), (String)"Should throw exception");
        IllegalArgumentException iae = BeanLanguageMethodMissingParenthesisTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Method name must start with a valid java identifier at position: 0 in method: --couldThisBeFoo(${body}, ${header.foo})", (Object)iae.getMessage());
    }

    public boolean couldThisBeFoo(String body, String header) {
        return "yes".equals(header);
    }
}

