/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanLanguageInvalidOGNLTest
extends ContextTestSupport {
    @Test
    public void testBeanLanguageInvalidOGNL() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").transform().method(MyReallyCoolBean.class, "getOther[xx");
            }
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should have thrown exception");
        RuntimeCamelException rce = BeanLanguageInvalidOGNLTest.assertIsInstanceOf(RuntimeCamelException.class, e);
        MethodNotFoundException mnfe = BeanLanguageInvalidOGNLTest.assertIsInstanceOf(MethodNotFoundException.class, rce.getCause());
        Assertions.assertEquals((Object)"getOther[xx", (Object)mnfe.getMethodName());
        ExpressionIllegalSyntaxException cause = BeanLanguageInvalidOGNLTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, mnfe.getCause());
        Assertions.assertEquals((Object)"Illegal syntax: getOther[xx", (Object)cause.getMessage());
        Assertions.assertEquals((Object)"getOther[xx", (Object)cause.getExpression());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyReallyCoolBean {
        private final Map<?, ?> map = new LinkedHashMap();

        public Map<?, ?> getOther() {
            return this.map;
        }
    }
}

