/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.bean.Bean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class BeanAnnotationParameterTwoTest
extends ContextTestSupport {
    @Test
    public void testBeanAnnotationOne() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.template.sendBody("direct:one", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanAnnotationTwo() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.template.sendBody("direct:two", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBeanAnnotationFour() throws Exception {
        this.getMockEndpoint("mock:middle").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:four", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("GreetingService", (Object)new GreetingService());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:one").bean(MyBean.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:two").bean(MyBean.class, "callA")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:four").bean(MyBean.class, "callA")).to("mock:middle")).bean(MyBean.class, "callB")).to("mock:result");
            }
        };
    }

    public static final class GreetingService {
        public String callA() {
            throw new IllegalArgumentException("Should not callA");
        }

        public String callB() {
            throw new IllegalArgumentException("Should not callB");
        }

        public String english() {
            return "Hello";
        }

        public String french() {
            return "Bonjour";
        }

        public String german() {
            return "Hallo";
        }
    }

    public static final class MyBean {
        public String callA(@Bean(ref="GreetingService", method="english") String greeting, @Bean(ref="GreetingService", method="french") String french, String body) {
            return greeting + "/" + french + " " + body;
        }

        public String callB() {
            return "Bye World";
        }
    }
}

