/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.function.Function;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LanguageBuilderFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.TypedExpressionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractTypedLanguageTest<T extends TypedExpressionDefinition.AbstractBuilder<T, E>, E extends TypedExpressionDefinition>
extends ContextTestSupport {
    protected final String expression;
    protected final Function<LanguageBuilderFactory, T> factory;

    protected AbstractTypedLanguageTest(String expression, Function<LanguageBuilderFactory, T> factory) {
        this.expression = expression;
        this.factory = factory;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    protected void assertResult(String uriSuffix, TestContext context) throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint(String.format("mock:%s", uriSuffix));
        mockEndpoint.expectedMessageCount(1);
        this.template.sendBody(String.format("direct:%s", uriSuffix), context.getContentToSend());
        this.assertMockEndpointsSatisfied();
        this.assertTypeInstanceOf(context.getBodyReceivedType(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
        this.assertBodyReceived(context.getBodyReceived(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
    }

    protected void assertTypeInstanceOf(Class<?> expected, Object body) {
        if (expected != null) {
            AbstractTypedLanguageTest.assertIsInstanceOf(expected, body);
        }
    }

    protected void assertBodyReceived(Object expected, Object body) {
        if (expected != null) {
            if (expected instanceof Integer && body instanceof Integer) {
                Assertions.assertEquals((int)((Integer)expected), (int)((Integer)body));
            } else {
                Assertions.assertEquals((Object)expected, (Object)body);
            }
        }
    }

    protected Object defaultContentToSend() {
        return "1";
    }

    protected TestContext testWithoutTypeContext() {
        return new TestContext(this.defaultContentToSend(), "1", String.class);
    }

    @Test
    void testExpressionOnly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:expression-only").setBody().expression((Expression)this.expression((Expression)((TypedExpressionDefinition.AbstractBuilder)((TypedExpressionDefinition.AbstractBuilder)AbstractTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractTypedLanguageTest.this.expression)).end()))).to("mock:expression-only");
            }
        });
        this.context.start();
        this.assertResult("expression-only", this.testWithoutTypeContext());
    }

    protected TestContext testWithTypeContext() {
        return new TestContext(this.defaultContentToSend(), 1, Integer.class);
    }

    @Test
    void testTypedWithClass() throws Exception {
        final TestContext testContext = this.testWithTypeContext();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:typed-with-class").setBody().expression((Expression)this.expression((Expression)((TypedExpressionDefinition.AbstractBuilder)((TypedExpressionDefinition.AbstractBuilder)AbstractTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractTypedLanguageTest.this.expression)).resultType(testContext.getBodyReceivedType()).end()))).to("mock:typed-with-class");
            }
        });
        this.context.start();
        this.assertResult("typed-with-class", testContext);
    }

    @Test
    void testTypedWithName() throws Exception {
        final TestContext testContext = this.testWithTypeContext();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:typed-with-name").split((Expression)this.expression((Expression)((TypedExpressionDefinition.AbstractBuilder)((TypedExpressionDefinition.AbstractBuilder)AbstractTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractTypedLanguageTest.this.expression)).resultTypeName(testContext.getBodyReceivedType().getName()).end())).to("mock:typed-with-name");
            }
        });
        this.context.start();
        this.assertResult("typed-with-name", testContext);
    }

    protected static class TestContext {
        private final Object contentToSend;
        private final Object bodyReceived;
        private final Class<?> bodyReceivedType;

        public TestContext(Object contentToSend, Object bodyReceived, Class<?> bodyReceivedType) {
            this.contentToSend = contentToSend;
            this.bodyReceived = bodyReceived;
            this.bodyReceivedType = bodyReceivedType;
        }

        public Object getContentToSend() {
            return this.contentToSend;
        }

        public Object getBodyReceived() {
            return this.bodyReceived;
        }

        public Class<?> getBodyReceivedType() {
            return this.bodyReceivedType;
        }
    }
}

