/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LanguageBuilderFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.language.AbstractTypedLanguageTest;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.SingleInputTypedExpressionDefinition;
import org.junit.jupiter.api.Test;

public abstract class AbstractSingleInputTypedLanguageTest<T extends SingleInputTypedExpressionDefinition.AbstractBuilder<T, E>, E extends SingleInputTypedExpressionDefinition>
extends AbstractTypedLanguageTest<T, E> {
    protected AbstractSingleInputTypedLanguageTest(String expression, Function<LanguageBuilderFactory, T> factory) {
        super(expression, factory);
    }

    @Test
    void testHeaderOnly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:header-only").setBody().expression((Expression)this.expression((Expression)((SingleInputTypedExpressionDefinition.AbstractBuilder)((SingleInputTypedExpressionDefinition.AbstractBuilder)AbstractSingleInputTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractSingleInputTypedLanguageTest.this.expression)).headerName("someHeader").end()))).to("mock:header-only");
            }
        });
        this.context.start();
        AbstractTypedLanguageTest.TestContext context = this.testWithoutTypeContext();
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:header-only");
        mockEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:header-only", (Object)"foo", "someHeader", context.getContentToSend());
        this.assertMockEndpointsSatisfied();
        this.assertBodyReceived(context.getBodyReceived(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
        this.assertTypeInstanceOf(context.getBodyReceivedType(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
    }

    @Test
    void testPropertyOnly() throws Exception {
        AbstractTypedLanguageTest.TestContext testContext = this.testWithoutTypeContext();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:property-only").setBody().expression((Expression)this.expression((Expression)((SingleInputTypedExpressionDefinition.AbstractBuilder)((SingleInputTypedExpressionDefinition.AbstractBuilder)AbstractSingleInputTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractSingleInputTypedLanguageTest.this.expression)).propertyName("someProperty").end()))).to("mock:property-only");
            }
        });
        this.context.start();
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:property-only");
        mockEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndProperty("direct:property-only", (Object)"foo", "someProperty", testContext.getContentToSend());
        this.assertMockEndpointsSatisfied();
        this.assertBodyReceived(testContext.getBodyReceived(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
        this.assertTypeInstanceOf(testContext.getBodyReceivedType(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
    }

    @Test
    void testHeaderAndType() throws Exception {
        final AbstractTypedLanguageTest.TestContext testContext = this.testWithTypeContext();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:header-and-type").setBody().expression((Expression)this.expression((Expression)((SingleInputTypedExpressionDefinition.AbstractBuilder)((SingleInputTypedExpressionDefinition.AbstractBuilder)((SingleInputTypedExpressionDefinition.AbstractBuilder)AbstractSingleInputTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractSingleInputTypedLanguageTest.this.expression)).headerName("someHeader").resultType(testContext.getBodyReceivedType())).end()))).to("mock:header-and-type");
            }
        });
        this.context.start();
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:header-and-type");
        mockEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:header-and-type", (Object)"foo", "someHeader", testContext.getContentToSend());
        this.assertMockEndpointsSatisfied();
        this.assertTypeInstanceOf(testContext.getBodyReceivedType(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
    }

    @Test
    void testPropertyAndType() throws Exception {
        final AbstractTypedLanguageTest.TestContext testContext = this.testWithTypeContext();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:property-and-type").setBody().expression((Expression)this.expression((Expression)((SingleInputTypedExpressionDefinition.AbstractBuilder)((SingleInputTypedExpressionDefinition.AbstractBuilder)((SingleInputTypedExpressionDefinition.AbstractBuilder)AbstractSingleInputTypedLanguageTest.this.factory.apply(this.expression())).expression(AbstractSingleInputTypedLanguageTest.this.expression)).propertyName("someProperty").resultType(testContext.getBodyReceivedType())).end()))).to("mock:property-and-type");
            }
        });
        this.context.start();
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:property-and-type");
        mockEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndProperty("direct:property-and-type", (Object)"foo", "someProperty", testContext.getContentToSend());
        this.assertMockEndpointsSatisfied();
        this.assertBodyReceived(testContext.getBodyReceived(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
        this.assertTypeInstanceOf(testContext.getBodyReceivedType(), ((Exchange)mockEndpoint.getReceivedExchanges().get(0)).getIn().getBody());
    }
}

