/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.language.xpath.XPathBuilder;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.InputSource;

public class XPathSplitStreamTest
extends ContextTestSupport {
    private static final int size = 100;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n<persons>");
        for (int i = 0; i < 100; ++i) {
            sb.append("\n<person><id>").append(i).append("</id><name>John Doe</name></person>");
        }
        sb.append("\n</persons>");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)sb.toString(), "CamelFileName", (Object)"bigfile.xml");
    }

    @Test
    public void testXPathSplitStream() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(100);
        mock.expectsNoDuplicates().body();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                XPathBuilder personXPath = XPathBuilder.xpath((String)"/persons/person").documentType(InputSource.class);
                this.from(XPathSplitStreamTest.this.fileUri("?initialDelay=0&delay=10")).split((Expression)personXPath).streaming().to("mock:split");
            }
        };
    }
}

