/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class WireTapFilterIssueTest
extends ContextTestSupport {
    private static final String BEFORE_FILTER = "mock:beforeFilter";
    private static final String MOCK_IN_FILTER = "mock:inFilter";
    private static final String MOCK_IN_SUBROUTE = "mock:inSubRoute";
    private static final String MOCK_AFTER_FILTER = "mock:afterFilter";
    private static final String DIRECT_START_WIRETAP_ROUTE = "direct:startWireTapRoute";
    private static final String DIRECT_START_REGULAR_TO_ROUTE = "direct:startRegularToRoute";
    private static final String DIRECT_SUBROUTE_ENDPOINT = "direct:subRoute";
    private static final String HEADER_FILTER = "filter";
    private MockEndpoint mockBeforeFilter;
    private MockEndpoint mockInFilter;
    private MockEndpoint mockInSubroute;
    private MockEndpoint mockAfterFilter;

    @AfterEach
    void afterEach() throws Exception {
        this.mockBeforeFilter.assertIsSatisfied();
        this.mockInFilter.assertIsSatisfied();
        this.mockInSubroute.assertIsSatisfied();
        this.mockAfterFilter.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        this.mockBeforeFilter = this.getMockEndpoint(BEFORE_FILTER);
        this.mockInFilter = this.getMockEndpoint(MOCK_IN_FILTER);
        this.mockInSubroute = this.getMockEndpoint(MOCK_IN_SUBROUTE);
        this.mockAfterFilter = this.getMockEndpoint(MOCK_AFTER_FILTER);
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from(WireTapFilterIssueTest.DIRECT_START_REGULAR_TO_ROUTE).to(WireTapFilterIssueTest.BEFORE_FILTER)).filter((Predicate)this.header(WireTapFilterIssueTest.HEADER_FILTER)).to(WireTapFilterIssueTest.MOCK_IN_FILTER)).to(WireTapFilterIssueTest.DIRECT_SUBROUTE_ENDPOINT)).end().to(WireTapFilterIssueTest.MOCK_AFTER_FILTER).end();
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from(WireTapFilterIssueTest.DIRECT_START_WIRETAP_ROUTE).to(WireTapFilterIssueTest.BEFORE_FILTER)).filter((Predicate)this.header(WireTapFilterIssueTest.HEADER_FILTER)).to(WireTapFilterIssueTest.MOCK_IN_FILTER)).wireTap(WireTapFilterIssueTest.DIRECT_SUBROUTE_ENDPOINT).end()).end().to(WireTapFilterIssueTest.MOCK_AFTER_FILTER).end();
                ((RouteDefinition)this.from(WireTapFilterIssueTest.DIRECT_SUBROUTE_ENDPOINT).to(WireTapFilterIssueTest.MOCK_IN_SUBROUTE)).end();
            }
        };
    }

    @Test
    void regularToFilterTrue() {
        this.expectFilter(true);
        this.sendExchange(DIRECT_START_REGULAR_TO_ROUTE, true);
    }

    @Test
    void regularToFilterFalse() {
        this.expectFilter(false);
        this.sendExchange(DIRECT_START_REGULAR_TO_ROUTE, false);
    }

    @Test
    void wireTapFilterTrue() {
        this.expectFilter(true);
        this.sendExchange(DIRECT_START_WIRETAP_ROUTE, true);
    }

    @Test
    void wireTapFilterFalse() {
        this.expectFilter(false);
        this.sendExchange(DIRECT_START_WIRETAP_ROUTE, false);
    }

    private void expectFilter(boolean filter) {
        this.mockBeforeFilter.expectedMessageCount(1);
        this.mockInFilter.expectedMessageCount(filter ? 1 : 0);
        this.mockInSubroute.expectedMessageCount(filter ? 1 : 0);
        this.mockAfterFilter.expectedMessageCount(1);
    }

    private void sendExchange(String directStart, boolean filtering) {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader(HEADER_FILTER, (Object)filtering);
        this.template.send(directStart, (Exchange)exchange);
    }
}

