/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.InterceptStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TwoTimerWithJMXIssueTest
extends ContextTestSupport {
    private static int counter;

    @Override
    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testFromWithNoOutputs() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((counter >= 2 ? 1 : 0) != 0, (String)"Counter should be 2 or higher");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TwoTimerWithJMXIssueTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new MyTracer());
                this.from("timer://kickoff_1?period=250").to("mock:result");
                this.from("timer://kickoff_2?period=250&delay=10").to("mock:result");
            }
        };
    }

    private static class MyTracer
    implements InterceptStrategy {
        private MyTracer() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) {
            Assertions.assertNotNull((Object)target);
            ++counter;
            return target;
        }
    }
}

