/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class TryCatchWithSplitIssueTest
extends ContextTestSupport {
    @Test
    public void testSplitWithErrorIsHandled() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"James"});
        ((MockValueBuilder)error.message(0).exchangeProperty("CamelExceptionCaught")).isNotNull();
        ((MockValueBuilder)error.message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hi Claus", "Hi Willem"});
        this.template.sendBody("direct:start", (Object)"Claus@James@Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitOnlyWithErrorIsHandled() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"James"});
        ((MockValueBuilder)error.message(0).exchangeProperty("CamelExceptionCaught")).isNotNull();
        ((MockValueBuilder)error.message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"James");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("error", (Object)new GenerateError());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TryCatchWithSplitIssueTest.this.context.setTracing(Boolean.valueOf(true));
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").split((Expression)this.body().tokenize("@")).doTry().to("bean:error")).to("mock:result")).doCatch(Exception.class).to("mock:error")).doFinally().to("mock:foo")).to("mock:bar")).end();
            }
        };
    }

    public static class GenerateError {
        public String dummyException(String payload) {
            if (payload.equals("James")) {
                throw new IllegalArgumentException("This is a dummy error James!");
            }
            return "Hi " + payload;
        }
    }
}

