/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Test;

public class TryCatchWireTapOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testTryCatchWireTapOnPrepare() throws Exception {
        MockEndpoint wireTapMockEndpoint = this.getMockEndpoint("mock:wireTap");
        wireTapMockEndpoint.expectedMessageCount(1);
        wireTapMockEndpoint.expectedPropertyReceived("valid", (Object)"false");
        this.getMockEndpoint("mock:valid").expectedMessageCount(0);
        this.getMockEndpoint("mock:invalid").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((CatchDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("direct:validator")).wireTap("mock:wireTap").onPrepare(exchange -> exchange.setProperty("valid", (Object)"true")).endDoTry().to("mock:valid")).doCatch(IllegalArgumentException.class).wireTap("mock:wireTap").onPrepare(exchange -> exchange.setProperty("valid", (Object)"false")).endDoCatch().to("mock:invalid")).end();
                this.from("direct:validator").throwException((Exception)new IllegalArgumentException("Not Valid"));
            }
        };
    }
}

