/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.spi.Policy;
import org.junit.jupiter.api.Test;

public class TransactedSetHeaderIssueTest
extends ContextTestSupport {
    private final Policy policy = new Policy(){

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, Processor processor) {
            return processor;
        }
    };

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testSetHeaderOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                TransactedSetHeaderIssueTest.this.context.getRegistry().bind("myPolicy", (Object)TransactedSetHeaderIssueTest.this.policy);
                ((TransactedDefinition)((TransactedDefinition)this.from("direct:start").transacted("myPolicy").setHeader("foo", (Expression)this.constant(123))).to("log:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)123);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetHeaderIssue() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                TransactedSetHeaderIssueTest.this.context.getRegistry().bind("myPolicy", (Object)TransactedSetHeaderIssueTest.this.policy);
                ((TransactedDefinition)((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant(123))).transacted("myPolicy").to("log:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)123);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

