/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Policy;
import org.junit.jupiter.api.Test;

public class TransactedPropertyPlaceholderIssueTest
extends ContextTestSupport {
    @Test
    public void testPropertyPlaceholder() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camel"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("seda:foo").policy((Policy)new MyDummyPolicy()).setBody().constant((Object)"{{cool.name}}")).to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        return context;
    }

    private static final class MyDummyPolicy
    implements Policy {
        private MyDummyPolicy() {
        }

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, Processor processor) {
            return processor;
        }
    }
}

