/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class TracingStandbyNoRouteTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setTracingStandby(true);
        return context;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAddRoute() throws Exception {
        this.context.start();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:bye").to("mock:bye");
            }
        });
        this.getMockEndpoint("mock:bye").expectedMessageCount(1);
        this.template.sendBody("direct:bye", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.context.getTracer().setEnabled(true);
        this.getMockEndpoint("mock:bye").expectedMessageCount(1);
        this.template.sendBody("direct:bye", (Object)"Hello Tracer");
        this.assertMockEndpointsSatisfied();
    }
}

