/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Test;

public class ThreadsRejectedExecutionWithDeadLetterTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testThreadsRejectedExecution() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)this.from("seda:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:failed")).to("log:before")).threads().maxPoolSize(1).poolSize(1).maxQueueSize(1).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.await(5L, TimeUnit.SECONDS);
                    }
                })).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:failed").expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        Thread.sleep(100L);
        latch.countDown();
        latch.countDown();
        latch.countDown();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThreadsRejectedExecutionWithRedelivery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)this.from("seda:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:failed").maximumRedeliveries(10).redeliveryDelay(100L)).to("log:before")).threads().maxPoolSize(1).poolSize(1).maxQueueSize(1).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        latch.await(500L, TimeUnit.MILLISECONDS);
                    }
                })).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        this.getMockEndpoint("mock:failed").expectedMessageCount(0);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        latch.countDown();
        latch.countDown();
        latch.countDown();
        this.assertMockEndpointsSatisfied();
    }
}

