/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.EndpointStrategy;
import org.junit.jupiter.api.Test;

public class ThreadsDoTryCatchInterceptSendToAllEndpointIssueTest
extends ContextTestSupport {
    @Test
    public void testThreadsTryCatch() throws Exception {
        this.getMockEndpoint("mock:log:try").expectedMessageCount(1);
        this.getMockEndpoint("mock:log:catch").expectedMessageCount(1);
        this.getMockEndpoint("mock:log:world").expectedMessageCount(1);
        this.getMockEndpoint("mock:log:other").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        this.context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy("*"));
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").threads().doTry().to("log:try")).throwException((Exception)new IllegalArgumentException("Forced"))).doCatch(Exception.class).to("log:catch")).choice().when(this.body().contains((Object)"World")).to("log:world")).stop()).otherwise().to("log:other")).stop()).end().end();
            }
        };
    }
}

