/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class StopRouteImpactsErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testIssue() throws Exception {
        RouteDefinition testRoute = this.context.getRouteDefinition("TestRoute");
        AdviceWith.adviceWith((RouteDefinition)testRoute, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().to("log:seda")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        RouteDefinition smtpRoute = this.context.getRouteDefinition("smtpRoute");
        AdviceWith.adviceWith((RouteDefinition)smtpRoute, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("smtp*").to("log:smtp")).skipSendToOriginalEndpoint().to("mock:smtp");
            }
        });
        this.getMockEndpoint("mock:smtp").expectedMessageCount(1);
        this.context.getRouteController().stopRoute("pollRoute");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StopRouteImpactsErrorHandlerTest.this.context.addComponent("smtp", StopRouteImpactsErrorHandlerTest.this.context.getComponent("mock"));
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("direct:emailSupport").maximumRedeliveries(2).redeliveryDelay(0L));
                this.from("direct:emailSupport").routeId("smtpRoute").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:dead?level=ERROR")).to("smtp://smtpServer");
                this.from("timer://someTimer?delay=15000&fixedRate=true&period=5000").routeId("pollRoute").to("log:level=INFO");
                this.from("direct:start").routeId("TestRoute").to("seda:foo");
            }
        };
    }
}

