/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StopRouteFromRouteTest {
    final CountDownLatch latch = new CountDownLatch(1);

    @Test
    public void testStopRouteFromRoute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)this.createMyRoutes());
        context.start();
        Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("myRoute").isStarted(), (String)"Route myRoute should be started");
        Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("bar").isStarted(), (String)"Route bar should be started");
        MockEndpoint start = (MockEndpoint)context.getEndpoint("mock:start", MockEndpoint.class);
        start.expectedMessageCount(1);
        MockEndpoint done = (MockEndpoint)context.getEndpoint("mock:done", MockEndpoint.class);
        done.expectedMessageCount(1);
        ProducerTemplate template = context.createProducerTemplate();
        template.sendBody("direct:start", (Object)"Hello Camel");
        this.latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("myRoute").isStopped(), (String)"Route myRoute should be stopped");
        Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("bar").isStarted(), (String)"Route bar should be started");
        context.stop();
        start.assertIsSatisfied();
        done.assertIsSatisfied();
    }

    public RouteBuilder createMyRoutes() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:start")).process(new Processor(){
                    Thread stop;

                    public void process(final Exchange exchange) {
                        if (this.stop == null) {
                            this.stop = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        exchange.getContext().getRouteController().stopRoute("myRoute");
                                    }
                                    catch (Exception exception) {
                                    }
                                    finally {
                                        StopRouteFromRouteTest.this.latch.countDown();
                                    }
                                }
                            };
                        }
                        this.stop.start();
                    }
                })).to("mock:done");
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

