/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RouteError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StopAndFailRouteTest
extends ContextTestSupport {
    @Test
    public void stopRoute() throws Exception {
        Route route = this.context.getRoute("foo");
        Assertions.assertNull((Object)route.getLastError());
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        RouteError re = route.getLastError();
        Assertions.assertNull((Object)re);
    }

    @Test
    public void failRoute() throws Exception {
        Route route = this.context.getRoute("bar");
        Assertions.assertNull((Object)route.getLastError());
        IllegalArgumentException cause = new IllegalArgumentException("Forced");
        this.context.getRouteController().stopRoute("bar", (Throwable)cause);
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("bar").name());
        RouteError re = route.getLastError();
        Assertions.assertNotNull((Object)re);
        Assertions.assertTrue((boolean)re.isUnhealthy());
        Assertions.assertEquals((Object)RouteError.Phase.STOP, (Object)re.getPhase());
        Assertions.assertSame((Object)cause, (Object)re.getException());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

