/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterUsingBeanReturningMessageTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("mySplitter", (Object)new MyOtherSplitterBean());
        return jndi;
    }

    @Test
    public void testSplitWithMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"not empty");
        ((MockValueBuilder)mock.message(0).header("type")).isEqualTo((Object)"TYPE1");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().method("mySplitter")).to(new String[]{"log:foo", "mock:result"});
            }
        };
    }

    public static class MyOtherSplitterBean {
        public List<?> split(Exchange exchange) {
            Message in = exchange.getIn();
            Assertions.assertNotNull((Object)in.toString());
            LinkedList<Message> msgs = new LinkedList<Message>();
            Message copy = in.copy();
            Assertions.assertNotNull((Object)copy.toString());
            copy.setBody((Object)"not empty");
            copy.setHeader("type", (Object)"TYPE1");
            msgs.add(copy);
            return msgs;
        }
    }
}

