/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Iterator;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.issues.MyCloseableIterator;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterUsingBeanReturningCloseableIteratorTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("mySplitter", (Object)new MyOtherSplitterBean());
        return jndi;
    }

    @Test
    public void testCloseableIterator() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello,World"), (String)"Exception should have been thrown");
        Assertions.assertTrue((boolean)MyCloseableIterator.getInstance().isClosed(), (String)"MyCloseableIterator.close() was not invoked");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().method("mySplitter")).to(new String[]{"log:foo", "mock:result"});
            }
        };
    }

    public static class MyOtherSplitterBean {
        public Iterator<String> split(Exchange exchange) {
            return MyCloseableIterator.getInstance();
        }
    }
}

