/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

public class SplitterThrowExceptionInExpressionTest
extends ContextTestSupport {
    @Test
    public void testSplitterAndVerifyMock() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:error2").expectedMessageCount(1);
        this.getMockEndpoint("mock:split").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(ExpressionEvaluationException.class).handled(true).to("mock://error");
                ((ExpressionNode)((OnExceptionDefinition)this.from("direct://start").onException(ExpressionEvaluationException.class).handled(true).to("mock://error2")).end().split((Expression)new MyExpression()).to("mock://split")).end().to("log:result");
            }
        };
    }

    private static class MyExpression
    implements Expression {
        private MyExpression() {
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            throw new ExpressionEvaluationException(null, exchange, null);
        }
    }
}

