/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Iterator;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterParallelWithIteratorThrowingExceptionTest
extends ContextTestSupport {
    @Test
    public void testIteratorThrowExceptionOnFirst() throws Exception {
        this.getMockEndpoint("mock:line").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)new MyIterator(1)), (String)"Should throw exception");
        IllegalArgumentException iae = SplitterParallelWithIteratorThrowingExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced error", (Object)iae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIteratorThrowExceptionOnSecond() throws Exception {
        this.getMockEndpoint("mock:line").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)new MyIterator(2)), (String)"Should throw exception");
        IllegalArgumentException iae = SplitterParallelWithIteratorThrowingExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced error", (Object)iae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIteratorThrowExceptionOnThird() throws Exception {
        this.getMockEndpoint("mock:line").expectedMessageCount(2);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)new MyIterator(3)), (String)"Should throw exception");
        IllegalArgumentException iae = SplitterParallelWithIteratorThrowingExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced error", (Object)iae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body()).aggregationStrategy((AggregationStrategy)new UseLatestAggregationStrategy()).streaming().stopOnException().parallelProcessing().parallelAggregate().to("mock:line")).end().to("mock:end");
            }
        };
    }

    public static class MyIterator
    implements Iterator<String> {
        private int count;

        public MyIterator(int count) {
            this.count = count;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            if (--this.count > 0) {
                return "Hello";
            }
            throw new IllegalArgumentException("Forced error");
        }
    }
}

