/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterParallelRuntimeExceptionInHasNextOrNextTest
extends ContextTestSupport {
    @Test
    public void testSplitErrorInHasNext() throws Exception {
        this.execute("direct:errorInHasNext");
    }

    @Test
    public void testSplitErrorInNext() throws Exception {
        this.execute("direct:errorInNext");
    }

    private void execute(String from) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody(from, (Object)"some content"), (String)"expected due to runtime exception in hasNext method");
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Exception occurred"));
            this.assertMockEndpointsSatisfied();
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:errorInHasNext").split().method(SplitterImpl.class, "errorInHasNext")).streaming().parallelProcessing(true).to("mock:split1");
                ((SplitDefinition)this.from("direct:errorInNext").split().method(SplitterImpl.class, "errorInNext")).streaming().parallelProcessing(true).to("mock:split2");
            }
        };
    }

    static class CustomIterator
    implements Iterator<String>,
    Closeable {
        private int index;
        private final InputStream request;
        private final boolean errorInHasNext;

        CustomIterator(Exchange exchange, InputStream request, boolean errorInHasNext) {
            this.request = request;
            this.errorInHasNext = errorInHasNext;
        }

        @Override
        public boolean hasNext() {
            if (this.index < 7) {
                return true;
            }
            if (this.errorInHasNext) {
                throw new RuntimeException("Exception thrown");
            }
            return false;
        }

        @Override
        public String next() {
            ++this.index;
            if (this.index < 7) {
                return "<a>" + this.index + "</a>";
            }
            if (!this.errorInHasNext) {
                throw new RuntimeException("Exception thrown");
            }
            return "<a>" + this.index + "</a>";
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.request.close();
        }
    }

    public static class SplitterImpl {
        public Iterator<String> errorInHasNext(InputStream request, Exchange exchange) {
            return new CustomIterator(exchange, request, true);
        }

        public Iterator<String> errorInNext(InputStream request, Exchange exchange) {
            return new CustomIterator(exchange, request, false);
        }
    }
}

