/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class SplitterParallelIssueTest
extends ContextTestSupport {
    private final int delay = 100;

    @Test
    public void testSplitParallel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        int size = 20;
        mock.expectedMessageCount(size);
        int time = 10000;
        mock.setResultWaitTime((long)time);
        int i = 0;
        while (i < size) {
            final int num = i++;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SplitterParallelIssueTest.this.template.sendBody("direct:start", (Object)Integer.toString(num));
                }
            }).start();
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)this.from("direct:start").log("Start ${body}")).split((Expression)this.body().tokenize("@"), (AggregationStrategy)new UseLatestAggregationStrategy()).parallelProcessing().streaming().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        int num = (Integer)exchange.getIn().getBody(Integer.TYPE);
                        long sleep = (long)num * 100L;
                        log.info("Sleep for {} ms", (Object)sleep);
                        Thread.sleep(sleep);
                    }
                })).end().log("End ${body}").to("mock:end");
            }
        };
    }
}

