/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterCorrelationIdIssueTest
extends ContextTestSupport {
    @Test
    public void testSplitCorrelationId() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        Exchange exchange = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"A,B,C");
            }
        });
        this.assertMockEndpointsSatisfied();
        String parent = exchange.getExchangeId();
        String split1 = ((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId();
        String split2 = ((Exchange)mock.getReceivedExchanges().get(1)).getExchangeId();
        String split3 = ((Exchange)mock.getReceivedExchanges().get(2)).getExchangeId();
        Assertions.assertNotSame((Object)parent, (Object)split1);
        Assertions.assertNotSame((Object)parent, (Object)split2);
        Assertions.assertNotSame((Object)parent, (Object)split3);
        Assertions.assertNotSame((Object)split1, (Object)split2);
        Assertions.assertNotSame((Object)split2, (Object)split3);
        Assertions.assertNotSame((Object)split3, (Object)split1);
        String corr1 = (String)((Exchange)mock.getReceivedExchanges().get(0)).getProperty("CamelCorrelationId", String.class);
        String corr2 = (String)((Exchange)mock.getReceivedExchanges().get(1)).getProperty("CamelCorrelationId", String.class);
        String corr3 = (String)((Exchange)mock.getReceivedExchanges().get(2)).getProperty("CamelCorrelationId", String.class);
        Assertions.assertEquals((Object)parent, (Object)corr1);
        Assertions.assertEquals((Object)parent, (Object)corr2);
        Assertions.assertEquals((Object)parent, (Object)corr3);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.body().tokenize(",")).to("mock:split");
            }
        };
    }
}

