/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterAggregationStrategyInputExchangeTest
extends ContextTestSupport {
    @Test
    public void testInputExchange() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        Exchange out = this.template.request("direct:start", p -> p.getMessage().setBody((Object)"A,B"));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"A,B", (Object)out.getMessage().getBody());
        Assertions.assertEquals((Object)"Forced", (Object)out.getMessage().getHeader("FailedDue"));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").split((Expression)this.body(), (AggregationStrategy)new MyAggregateBean()).choice().when(this.body().contains((Object)"A")).to("direct:a")).otherwise().to("direct:b")).end().end();
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").setHeader("foo", (Expression)this.constant("123"))).transform((Expression)this.constant("A"))).to("mock:a");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:b").setHeader("bar", (Expression)this.constant("456"))).transform((Expression)this.constant("B"))).throwException((Exception)new IllegalArgumentException("Forced"))).to("mock:b");
            }
        };
    }

    public static class MyAggregateBean
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            return null;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
            if (newExchange.isFailed()) {
                inputExchange.getMessage().setHeader("FailedDue", (Object)newExchange.getException().getMessage());
                return inputExchange;
            }
            return newExchange;
        }
    }
}

