/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitWithInterceptorTest
extends ContextTestSupport {
    private final MyInterceptStrategy interceptStrategy = new MyInterceptStrategy();

    @Test
    public void testSplitOne() throws Exception {
        this.interceptStrategy.reset();
        this.getMockEndpoint("mock:line").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)MyInterceptStrategy.doneCount, (String)"Done method shall be called only once");
    }

    @Test
    public void testSplitTwo() throws Exception {
        this.interceptStrategy.reset();
        this.getMockEndpoint("mock:line").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)MyInterceptStrategy.doneCount, (String)"Done method shall be called only once");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SplitWithInterceptorTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)SplitWithInterceptorTest.this.interceptStrategy);
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).to("log:line")).to("mock:line")).end().to("mock:result");
            }
        };
    }

    public static class MyInterceptStrategy
    implements InterceptStrategy {
        private static final Logger LOGGER = LoggerFactory.getLogger(MyInterceptStrategy.class);
        private static int doneCount;

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) {
            if (definition instanceof SplitDefinition) {
                DelegateAsyncProcessor delegateAsyncProcessor = new DelegateAsyncProcessor(){

                    public boolean process(Exchange exchange, final AsyncCallback callback) {
                        LOGGER.info("I'm doing someting");
                        return super.process(exchange, new AsyncCallback(){

                            public void done(boolean doneSync) {
                                LOGGER.info("I'm done");
                                ++doneCount;
                                callback.done(doneSync);
                            }
                        });
                    }
                };
                delegateAsyncProcessor.setProcessor(target);
                return delegateAsyncProcessor;
            }
            return new DelegateAsyncProcessor(target);
        }

        public void reset() {
            doneCount = 0;
        }
    }
}

