/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SplitWithCustomAggregationStrategyTest
extends ContextTestSupport {
    @Test
    public void testSplitWithCustomAggregatorStrategy() throws Exception {
        int files = 10;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(files);
        mock.expectsNoDuplicates((Expression)SplitWithCustomAggregationStrategyTest.body());
        for (int i = 0; i < files; ++i) {
            this.template.sendBody("direct:start", (Object)"");
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:start").setBody().simple("<search><key>foo-${id}</key><key>bar-${id}</key><key>baz-${id}</key></search>")).to("direct:splitInOut")).to("mock:result");
                ((ExpressionNode)((ProcessorDefinition)this.from("direct:splitInOut").setHeader("com.example.id").simple("${id}")).split((Expression)this.xpath("/search/key"), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String oldBody = (String)oldExchange.getIn().getBody(String.class);
                        String newBody = (String)newExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(oldBody + newBody));
                        return oldExchange;
                    }
                }).parallelProcessing().streaming().to("direct:processLine")).end().transform().simple("<results>${in.body}</results>");
                ((RouteDefinition)this.from("direct:processLine").to("log:line")).transform().simple("<index>${in.header.CamelSplitIndex}</index>${in.body}");
            }
        };
    }
}

