/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitStopOnExceptionIssueTest
extends ContextTestSupport {
    @Test
    public void testSplit() throws Exception {
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Hello", "World", "Kaboom"});
        ((MockValueBuilder)this.getMockEndpoint("mock:line").allMessages().exchangeProperty("foo")).isEqualTo((Object)"changed");
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello,World,Kaboom");
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertFalse((boolean)out.hasOut());
        Assertions.assertEquals((Object)"before", (Object)out.getProperty("foo"));
        Assertions.assertEquals((Object)"Hello,World,Kaboom", (Object)out.getIn().getBody());
        IllegalArgumentException iae = (IllegalArgumentException)out.getException(IllegalArgumentException.class);
        Assertions.assertNotNull((Object)iae);
        Assertions.assertEquals((Object)"Forced exception", (Object)iae.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((SplitDefinition)((RouteDefinition)this.from("direct:start").setProperty("foo", (Expression)this.constant("before"))).split().tokenize(",")).setProperty("foo", (Expression)this.constant("changed"))).to("mock:line")).filter(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Forced exception"))).end().end().to("mock:result");
            }
        };
    }
}

