/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SplitPropertiesFileIssueTest
extends ContextTestSupport {
    private final String body = "foo=1" + LS + "bar=2" + LS + "bar=3" + LS + "foo=4";

    @Test
    public void testSplitPropertiesFileAndRoute() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"[foo=1, foo=4]"});
        foo.expectedFileExists(this.testFile("done/myprop.txt"), this.body);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedBodiesReceived(new Object[]{"[bar=2, bar=3]"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)this.body, "CamelFileName", (Object)"myprop.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(SplitPropertiesFileIssueTest.this.fileUri("?initialDelay=0&delay=10&move=done")).convertBodyTo(String.class)).split((Expression)new MyCustomExpression()).recipientList((Expression)this.header("myCustomDestination"));
            }
        };
    }

    private static class MyCustomExpression
    implements Expression {
        private MyCustomExpression() {
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String[] lines;
            Message msg1 = exchange.getIn().copy();
            Message msg2 = exchange.getIn().copy();
            ArrayList<Message> answer = new ArrayList<Message>();
            answer.add(msg1);
            answer.add(msg2);
            ArrayList<String> data1 = new ArrayList<String>();
            ArrayList<String> data2 = new ArrayList<String>();
            String body = (String)exchange.getIn().getBody(String.class);
            for (String line : lines = body.split(LS)) {
                if (line.startsWith("foo")) {
                    data1.add(line);
                    continue;
                }
                data2.add(line);
            }
            msg1.setBody((Object)((Object)data1).toString());
            msg1.setHeader("myCustomDestination", (Object)"mock:foo");
            msg2.setBody((Object)((Object)data2).toString());
            msg2.setHeader("myCustomDestination", (Object)"mock:bar");
            return (T)answer;
        }
    }
}

