/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitContinuedLogIssueTest
extends ContextTestSupport {
    @Test
    public void testFooBar() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"bar"});
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"foo", "bar"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"foo=bar"});
        String out = (String)this.template.requestBody("direct:start", (Object)"foo,bar", String.class);
        Assertions.assertEquals((Object)"foo=bar", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBarFoo() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"bar"});
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"bar", "foo"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"bar=foo"});
        String out = (String)this.template.requestBody("direct:start", (Object)"bar,foo", String.class);
        Assertions.assertEquals((Object)"bar=foo", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).continued(true).logContinued(false).to(new String[]{"log:error", "mock:error"});
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body(), (AggregationStrategy)new SplitAggregationStrategy()).shareUnitOfWork().to("mock:line")).filter((Predicate)this.simple("${body} == 'bar'")).throwException((Exception)new IllegalArgumentException("Forced"))).end().end().to("log:result").to("mock:result");
            }
        };
    }

    private static class SplitAggregationStrategy
    implements AggregationStrategy {
        private SplitAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String s1 = (String)oldExchange.getIn().getBody(String.class);
            String s2 = (String)newExchange.getIn().getBody(String.class);
            String body = s1 + "=" + s2;
            oldExchange.getIn().setBody((Object)body);
            return oldExchange;
        }
    }
}

