/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SetHeaderInDoCatchIssueTest
extends ContextTestSupport {
    @Test
    public void testSuccess() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
            }
        });
        Assertions.assertEquals((Object)"CamsResponse", (Object)exchange.getMessage().getHeader("Status"));
    }

    @Test
    public void testExchangeTimedOutException() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"ExchangeTimedOutException");
            }
        });
        Assertions.assertEquals((Object)"TimeOut", (Object)exchange.getMessage().getHeader("Status"));
    }

    @Test
    public void testException() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Exception");
            }
        });
        Assertions.assertEquals((Object)"ExceptionGeneral", (Object)exchange.getMessage().getHeader("Status"));
    }

    @Override
    protected Registry createCamelRegistry() {
        DefaultRegistry registry = new DefaultRegistry();
        registry.bind("A", (Object)new Processor(){

            public void process(Exchange exchange) {
                SetHeaderInDoCatchIssueTest.this.log.info("A headers {}", (Object)exchange.getIn().getHeaders());
            }
        });
        registry.bind("B", (Object)new Processor(){

            public void process(Exchange exchange) throws Exception {
                SetHeaderInDoCatchIssueTest.this.log.info("B headers {}", (Object)exchange.getIn().getHeaders());
                if ("ExchangeTimedOutException".equals(exchange.getIn().getBody(String.class))) {
                    throw new ExchangeTimedOutException(exchange, 1L);
                }
                if ("Exception".equals(exchange.getIn().getBody(String.class))) {
                    throw new Exception();
                }
            }
        });
        registry.bind("C", (Object)new Processor(){

            public void process(Exchange exchange) {
                SetHeaderInDoCatchIssueTest.this.log.info("C headers {}", (Object)exchange.getIn().getHeaders());
            }
        });
        return registry;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SetHeaderInDoCatchIssueTest.this.context.setTracing(Boolean.valueOf(true));
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("bean:A")).setHeader("CamelJmsDestinationName", (Expression)this.constant("queue:outQueue"))).to(ExchangePattern.InOut, "bean:B")).setHeader("Status", (Expression)this.constant("CamsResponse"))).doCatch(ExchangeTimedOutException.class).setHeader("Status", (Expression)this.constant("TimeOut"))).doCatch(Exception.class).setHeader("Status", (Expression)this.constant("ExceptionGeneral"))).end().to("bean:C").transform((Expression)this.body());
            }
        };
    }
}

