/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SentExchangeEventNotifierTwoIssueTest
extends ContextTestSupport {
    private final MyNotifier notifier = new MyNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    @Test
    public void testExchangeSentNotifier() {
        this.notifier.reset();
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"I was here", (Object)out);
        Assertions.assertEquals((int)2, (int)this.notifier.getCounter());
    }

    @Test
    public void testExchangeSentNotifierExchange() {
        this.notifier.reset();
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertEquals((Object)"I was here", (Object)out.getIn().getBody());
        Assertions.assertEquals((int)2, (int)this.notifier.getCounter());
    }

    @Test
    public void testExchangeSentNotifierManualExchange() {
        this.notifier.reset();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        this.template.send("direct:start", (Exchange)exchange);
        Assertions.assertEquals((Object)"I was here", (Object)exchange.getIn().getBody());
        Assertions.assertEquals((int)2, (int)this.notifier.getCounter());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setBody((Object)"I was here");
                    }
                })).to("mock:result");
            }
        };
    }

    private static class MyNotifier
    extends EventNotifierSupport {
        private int counter;

        private MyNotifier() {
        }

        public void notify(CamelEvent event) {
            ++this.counter;
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeSentEvent;
        }

        public int getCounter() {
            return this.counter;
        }

        public void reset() {
            this.counter = 0;
        }
    }
}

