/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SedaFileIdempotentIssueTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final FileIdempotentRepository repository = new FileIdempotentRepository();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.testDirectory("inbox", true);
        try (OutputStream fos = Files.newOutputStream(this.testFile("inbox/hello.txt"), new OpenOption[0]);){
            fos.write("Hello World".getBytes());
        }
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        this.repository.setFileStore(this.testFile("repo.txt").toFile());
        jndi.bind("repo", (Object)this.repository);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(RuntimeException.class).process((Processor)new ShutDown());
                ((RouteDefinition)this.from(SedaFileIdempotentIssueTest.this.fileUri("inbox?idempotent=true&noop=true&idempotentRepository=#repo&initialDelay=0&delay=10")).to("log:begin")).to(ExchangePattern.InOut, "seda:process");
                this.from("seda:process").throwException((Exception)new RuntimeException("Testing with exception"));
            }
        };
    }

    @Test
    public void testRepo() throws Exception {
        boolean done = this.latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Should stop Camel");
        Assertions.assertEquals((int)0, (int)this.repository.getCache().keySet().size(), (String)"No file should be reported consumed");
    }

    protected class ShutDown
    implements Processor {
        protected ShutDown() {
        }

        public void process(final Exchange exchange) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        SedaFileIdempotentIssueTest.this.log.info("Stopping Camel");
                        exchange.getContext().stop();
                        SedaFileIdempotentIssueTest.this.log.info("Stopped Camel complete");
                        SedaFileIdempotentIssueTest.this.latch.countDown();
                    }
                    catch (Exception e) {
                        SedaFileIdempotentIssueTest.this.log.trace("Exception was thrown (safe to ignore): {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            };
            thread.start();
        }
    }
}

