/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SameRouteAndContextScopedErrorHandlerIssueTest
extends ContextTestSupport {
    private final AtomicInteger counter = new AtomicInteger();

    @Test
    public void testSame() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.counter.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(2).redeliveryDelay(0L));
                this.onException(IllegalArgumentException.class).onRedelivery(new Processor(){

                    public void process(Exchange exchange) {
                        log.info("OnRedelivery invoked");
                        SameRouteAndContextScopedErrorHandlerIssueTest.this.counter.incrementAndGet();
                    }
                });
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(2).redeliveryDelay(0L)).process(new Processor(){
                    private int counter;

                    public void process(Exchange exchange) {
                        if (this.counter++ < 2) {
                            throw new IllegalArgumentException("Damn");
                        }
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("log:result")).to("mock:result");
            }
        };
    }
}

