/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSlipWithInterceptorTest
extends ContextTestSupport {
    private final MyInterceptStrategy interceptStrategy = new MyInterceptStrategy();

    @Test
    public void testRoutingSlipOne() throws Exception {
        this.interceptStrategy.reset();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "slip", (Object)"direct:foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)MyInterceptStrategy.doneCount, (String)"Done method shall be called only once");
    }

    @Test
    public void testRoutingSlipTwo() throws Exception {
        this.interceptStrategy.reset();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "slip", (Object)"direct:foo,direct:bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)MyInterceptStrategy.doneCount, (String)"Done method shall be called only once");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                RoutingSlipWithInterceptorTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)RoutingSlipWithInterceptorTest.this.interceptStrategy);
                this.from("direct:start").routingSlip((Expression)this.header("slip")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").to("log:foo")).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").to("log:bar")).to("mock:bar");
            }
        };
    }

    public static class MyInterceptStrategy
    implements InterceptStrategy {
        private static final Logger LOGGER = LoggerFactory.getLogger(MyInterceptStrategy.class);
        private static int doneCount;

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) {
            if (definition instanceof RoutingSlipDefinition) {
                DelegateAsyncProcessor delegateAsyncProcessor = new DelegateAsyncProcessor(){

                    public boolean process(Exchange exchange, final AsyncCallback callback) {
                        LOGGER.info("I'm doing someting");
                        return super.process(exchange, new AsyncCallback(){

                            public void done(boolean doneSync) {
                                LOGGER.info("I'm done");
                                ++doneCount;
                                callback.done(doneSync);
                            }
                        });
                    }
                };
                delegateAsyncProcessor.setProcessor(target);
                return delegateAsyncProcessor;
            }
            return new DelegateAsyncProcessor(target);
        }

        public void reset() {
            doneCount = 0;
        }
    }
}

