/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class RoutingSlipNotStopErrorHandlerTest
extends ContextTestSupport {
    private static final String DIRECT_START = "direct:start";
    private static final String THROWING_ROUTE = "direct:throwingRoute";

    @Test
    public void testRoutingSlipNotStopErrorHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody(DIRECT_START, (Object)"ABC");
        this.template.sendBody(THROWING_ROUTE, (Object)"123");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:result").maximumRedeliveries(1).redeliveryDelay(10L).retriesExhaustedLogLevel(LoggingLevel.ERROR).retryAttemptedLogLevel(LoggingLevel.WARN).logStackTrace(true).logRetryStackTrace(true));
                this.from(RoutingSlipNotStopErrorHandlerTest.DIRECT_START).routingSlip((Expression)this.method(CustomRoutingSlip.class, "router"));
                this.from(RoutingSlipNotStopErrorHandlerTest.THROWING_ROUTE).process().exchange(o -> {
                    throw new IllegalStateException();
                });
            }
        };
    }

    public static class CustomRoutingSlip {
        public String router() {
            return RoutingSlipNotStopErrorHandlerTest.THROWING_ROUTE;
        }
    }
}

