/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.RoutingSlip;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingSlipMemoryLeakTest
extends ContextTestSupport {
    @Test
    public void testMemoryLeakInExceptionHandlerCaching() {
        int messageCount = 100;
        for (int i = 0; i < messageCount; ++i) {
            this.template.sendBody("direct:start", (Object)("message " + i));
        }
        RoutingSlip routingSlip = (RoutingSlip)this.context.getProcessor("memory-leak", RoutingSlip.class);
        Assertions.assertNotNull((Object)routingSlip);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                this.from("direct:start").routingSlip((Expression)this.method(SlipProvider.class)).id("memory-leak");
            }
        };
    }

    public class SlipProvider {
        public String computeSlip(String body) {
            return RoutingSlipMemoryLeakTest.this.fileUri();
        }
    }
}

