/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteStartupFailShouldStopAlsoIssueTest
extends ContextTestSupport {
    private static final List<String> EVENTS = new ArrayList<String>();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testShouldAlsoStop() throws Exception {
        this.context.addComponent("my", (Component)new MyComponent((CamelContext)this.context));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("my:foo").routeId("foo").to("mock:foo");
            }
        });
        Assertions.assertThrows(Exception.class, () -> this.context.start(), (String)"Should fail");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped());
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("bar").isStopped());
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("bar").isStarted());
        Assertions.assertFalse((boolean)this.context.getStatus().isStarted());
        Assertions.assertTrue((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)3, (int)EVENTS.size());
        Assertions.assertEquals((Object)"constructor", (Object)EVENTS.get(0));
        Assertions.assertEquals((Object)"doStart", (Object)EVENTS.get(1));
        Assertions.assertEquals((Object)"doStop", (Object)EVENTS.get(2));
    }

    private static class MyComponent
    extends DefaultComponent {
        public MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyEndpoint(uri, (Component)this);
        }
    }

    private static class MyFailConsumer
    extends DefaultConsumer {
        public MyFailConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
            EVENTS.add("constructor");
        }

        protected void doStart() throws Exception {
            super.doStart();
            EVENTS.add("doStart");
            throw new IllegalStateException("Forced failure");
        }

        protected void doStop() throws Exception {
            super.doStop();
            EVENTS.add("doStop");
        }
    }

    private static class MyEndpoint
    extends DefaultEndpoint {
        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() {
            throw new UnsupportedOperationException("Not supported");
        }

        public Consumer createConsumer(Processor processor) {
            return new MyFailConsumer((Endpoint)this, processor);
        }
    }
}

