/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.net.ConnectException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteScopedOnExceptionWithInterceptSendToEndpointIssueTest
extends ContextTestSupport {
    @Test
    public void testIssue() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new ConnectException("Forced"));
            }
        });
        this.getMockEndpoint("mock:global").expectedMessageCount(0);
        this.getMockEndpoint("mock:seda").expectedMessageCount(0);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(1);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should thrown an exception");
        ConnectException cause = RouteScopedOnExceptionWithInterceptSendToEndpointIssueTest.assertIsInstanceOf(ConnectException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:global").maximumRedeliveries(2).redeliveryDelay(5000L));
                ((OnExceptionDefinition)this.from("direct:start").onException(ConnectException.class).maximumRedeliveries(5).redeliveryDelay(0L).logRetryAttempted(true).retryAttemptedLogLevel(LoggingLevel.WARN).to("mock:exhausted")).end().to("seda:foo");
            }
        };
    }
}

