/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteScopedErrorHandlerAndOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testOnException() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new ConnectException("Forced"));
            }
        });
        this.getMockEndpoint("mock:local").expectedMessageCount(0);
        this.getMockEndpoint("mock:seda").expectedMessageCount(0);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(1);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should thrown an exception");
        ConnectException cause = RouteScopedErrorHandlerAndOnExceptionTest.assertIsInstanceOf(ConnectException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testErrorHandler() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new FileNotFoundException("Forced"));
            }
        });
        this.getMockEndpoint("mock:local").expectedMessageCount(1);
        this.getMockEndpoint("mock:seda").expectedMessageCount(0);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:local").maximumRedeliveries(2).redeliveryDelay(0L)).onException(ConnectException.class).maximumRedeliveries(5).redeliveryDelay(0L).logRetryAttempted(true).retryAttemptedLogLevel(LoggingLevel.WARN).to("mock:exhausted")).end().to("seda:foo");
            }
        };
    }
}

