/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;

public class RouteIdAutoAssignClashIssue
extends ContextTestSupport {
    public void testRouteIdAutoAssignClash() throws Exception {
        this.getMockEndpoint("mock:start1").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:start2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Hi Camel"});
        this.template.sendBody("direct:start1", (Object)"Hello World");
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)3, (int)this.context.getRoutes().size());
        Assertions.assertNotNull((Object)this.context.getRoute("route1"));
        Assertions.assertNotNull((Object)this.context.getRoute("route2"));
        Assertions.assertNotNull((Object)this.context.getRoute("route3"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start1").routeId("route1").to("mock:start1");
                this.from("direct:start2").routeId("route2").to("mock:start2");
                this.from("direct:start").to("mock:start");
            }
        };
    }
}

