/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.NodeIdFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteIdAnonymousAndFixedClashTest
extends ContextTestSupport {
    @Test
    public void testClash() {
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertNotNull((Object)this.context.getRoute("route1"), (String)"Should have route1 (fixed id");
        Assertions.assertNotNull((Object)this.context.getRoute("route2"), (String)"Should have route2 (auto assigned id)");
    }

    @Override
    protected CamelContext createCamelContext() {
        DefaultCamelContext ctx = new DefaultCamelContext(true);
        ctx.getCamelContextExtension().addContextPlugin(NodeIdFactory.class, (Object)new NodeIdFactory(){
            final AtomicInteger counter = new AtomicInteger();

            public String createId(NamedNode definition) {
                return definition.getShortName() + this.counter.incrementAndGet();
            }
        });
        return ctx;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:in1").id("route1")).to("mock:test1");
                this.from("direct:in2").to("mock:test2");
            }
        };
    }
}

