/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RetryWhileSimpleExpressionIssueTest
extends ContextTestSupport {
    @Test
    public void testRetryWhileSimple() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:error").message(0).body()).isInstanceOf(MyCoolDude.class);
        MyCoolDude dude = new MyCoolDude();
        this.template.sendBody("direct:start", (Object)dude);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)dude.getCounter());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).retryWhile((Predicate)this.simple("${body.areWeCool} == 'no'")).redeliveryDelay(0L).handled(true).to("mock:error");
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyCoolDude {
        private int counter;

        public String areWeCool() {
            if (this.counter++ < 3) {
                return "no";
            }
            return "yes";
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

