/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RetryRouteScopedUntilRecipientListIssueTest
extends ContextTestSupport {
    private final AtomicInteger invoked = new AtomicInteger();

    @BeforeEach
    public void resetInvoked() {
        this.invoked.set(0);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myRetryBean", (Object)new MyRetryBean());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addEndpoint("fail", (Endpoint)new DefaultEndpoint(){

            public Producer createProducer() {
                return new DefaultProducer((Endpoint)this){

                    public void process(Exchange exchange) {
                        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
                    }
                };
            }

            public Consumer createConsumer(Processor processor) {
                return null;
            }

            protected String createEndpointUri() {
                return "fail";
            }

            public boolean isSingleton() {
                return true;
            }
        });
        context.addEndpoint("not-fail", (Endpoint)new DefaultEndpoint(){

            public Producer createProducer() {
                return new DefaultProducer((Endpoint)this){

                    public void process(Exchange exchange) {
                    }
                };
            }

            public Consumer createConsumer(Processor processor) {
                return null;
            }

            protected String createEndpointUri() {
                return "not-fail";
            }

            public boolean isSingleton() {
                return true;
            }
        });
        return context;
    }

    @Test
    public void testRetryUntilRecipientListOkOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"direct:foo");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertEquals((int)0, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientListOkNotFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"direct:foo,not-fail");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertEquals((int)0, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientListFailOnly() throws Exception {
        NotifyBuilder event = this.event().whenDone(2).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)matches);
        this.context.stop();
        Assertions.assertEquals((int)3, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientListFailAndOk() throws Exception {
        NotifyBuilder event = this.event().whenDone(3).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"fail,direct:foo");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)matches);
        this.context.stop();
        Assertions.assertEquals((int)3, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientListOkAndFail() throws Exception {
        NotifyBuilder event = this.event().whenDone(3).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"direct:foo,fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)matches);
        this.context.stop();
        Assertions.assertEquals((int)3, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientNotFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"not-fail");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertEquals((int)0, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientFailAndNotFail() throws Exception {
        NotifyBuilder event = this.event().whenDone(3).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"fail,not-fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)matches);
        this.context.stop();
        Assertions.assertEquals((int)3, (int)this.invoked.get());
    }

    @Test
    public void testRetryUntilRecipientNotFailAndFail() throws Exception {
        NotifyBuilder event = this.event().whenDone(3).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"not-fail,fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)matches);
        this.context.stop();
        Assertions.assertEquals((int)3, (int)this.invoked.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:start").onException(Exception.class).redeliveryDelay(0L).retryWhile((Predicate)this.method("myRetryBean")).end().recipientList((Expression)this.header("recipientListHeader")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").to("log:foo")).to("mock:foo");
            }
        };
    }

    public class MyRetryBean {
        public boolean retry(@Header(value="CamelRedeliveryCounter") Integer counter, @Body String body, @ExchangeException Exception causedBy) {
            RetryRouteScopedUntilRecipientListIssueTest.this.invoked.incrementAndGet();
            return counter < 3;
        }
    }
}

