/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RecipientListUseOriginalMessageIssueTest
extends ContextTestSupport {
    @Test
    public void testRecipientListUseOriginalMessageIssue() throws Exception {
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri("inbox"), (Object)"A", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        RecipientListUseOriginalMessageIssueTest.assertFileExists(this.testFile("outbox/hello.txt"), "A");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).useOriginalMessage().to(RecipientListUseOriginalMessageIssueTest.this.fileUri("outbox"))).to("mock:error");
                ((RouteDefinition)((RouteDefinition)this.from(RecipientListUseOriginalMessageIssueTest.this.fileUri("inbox?initialDelay=0&delay=10")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setBody((Object)"B");
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setHeader("path", (Object)"xxx");
                    }
                })).recipientList((Expression)this.header("path"));
            }
        };
    }
}

