/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RecipientListUseOriginalMessageEndpointExceptionIssueTest
extends ContextTestSupport {
    @BeforeEach
    void setupMocks() {
        this.getMockEndpoint("mock:throwException").whenAnyExchangeReceived(exchange -> {
            throw new Exception("Exception raised");
        });
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:error").expectedFileExists(this.testFile("outbox/hello.txt"), "A");
    }

    @Test
    public void testRecipientListUseOriginalMessageIssue() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("inbox"), (Object)"A", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).useOriginalMessage().to(RecipientListUseOriginalMessageEndpointExceptionIssueTest.this.fileUri("outbox"))).to("mock:error");
                ((RouteDefinition)((RouteDefinition)this.from(RecipientListUseOriginalMessageEndpointExceptionIssueTest.this.fileUri("inbox?initialDelay=100&delay=10")).transform((Expression)this.constant("B"))).setHeader("path", (Expression)this.constant("mock:throwException"))).recipientList((Expression)this.header("path")).shareUnitOfWork();
            }
        };
    }
}

