/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListShareUnitOfWorkOnExceptionHandledFalseIssueTest
extends ContextTestSupport {
    @Test
    public void testRecipientList() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:b,direct:c"), (String)"Should throw exception");
        IllegalArgumentException cause = RecipientListShareUnitOfWorkOnExceptionHandledFalseIssueTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(false).to("mock:a");
                this.from("direct:start").recipientList((Expression)this.header("foo")).shareUnitOfWork().stopOnException().to("mock:result");
                this.from("direct:b").to("mock:b");
                ((RouteDefinition)this.from("direct:c").to("mock:c")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

