/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RecipientListParallelWithAggregationStrategyThrowingExceptionTest
extends ContextTestSupport {
    @Test
    public void testAggregationTimeExceptionWithParallelProcessing() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "recipients", (Object)"mock:a,mock:b");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("direct:start").recipientList((Expression)this.header("recipients")).aggregationStrategy((AggregationStrategy)new MyAggregateBean()).parallelProcessing().shareUnitOfWork().end()).to("mock:end");
            }
        };
    }

    public static class MyAggregateBean
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange != null) {
                throw new RuntimeException("Simulating a runtime exception thrown from the aggregation strategy");
            }
            return newExchange;
        }
    }
}

