/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RecipientListErrorHandlingIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testUsingInterceptor() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true).to("mock:error");
                this.interceptSendToEndpoint("direct:*").process(new Processor(){

                    public void process(Exchange exchange) {
                        String target = (String)exchange.getProperty("CamelInterceptedEndpoint", String.class);
                        exchange.getIn().setHeader("target", (Object)target);
                    }
                });
                this.from("direct:start").recipientList((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:kaboom").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:error").message(0).header("target")).isEqualTo((Object)"direct://kaboom");
        String foo = "direct:foo,direct:kaboom";
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)foo);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUsingExistingHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true).to("mock:error");
                this.from("direct:start").recipientList((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:kaboom").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:error").message(0).exchangeProperty("CamelFailureEndpoint")).isEqualTo((Object)"direct://kaboom");
        String foo = "direct:foo,direct:kaboom";
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)foo);
        this.assertMockEndpointsSatisfied();
    }
}

